"""GNUmed database pruning DML generator.

This script generates DML for pruning database tables
before restoring backups.

Theory of operation:

The script reads a plaintext format database backup of the
--data-only variety as generated by pg_dump and creates the
approprated DML commands to prune the tables which are
inserted into by the backup.

It is useful to pre-process the dump with:

	cut -f -5 -d " " data-only-dump.sql | grep -E "^(SET)|(INSERT)"

to weed out superfluous cruft.
"""
#==================================================================
# $Source: /sources/gnumed/gnumed/gnumed/server/bootstrap/gmDBPruningDMLGenerator.py,v $
__version__ = "$Revision: 1.1 $"
__author__ = "Karsten.Hilbert@gmx.net"
__license__ = "GPL (details at http://www.gnu.org)"

import sys, os.path, codecs


if __name__ == '__main__':
	sys.path.insert(0, '../../')
from Gnumed.pycommon import gmLog


_log = gmLog.gmDefLog
_log.Log(gmLog.lInfo, __version__)

#==================================================================
def generate_pruning_dml(filename=None):

	# FIXME: encoding may need configuration
	backup_file = codecs.open(filename = filename, mode = 'rU', encoding = 'utf8')
	backup_path, name = os.path.split(filename)
	name, ext = os.path.splitext(name)
	dml_name = os.path.join(backup_path, '%s-prune_tables.sql' % name)
	dml_file = codecs.open(filename = dml_name, mode = 'w', encoding = 'utf8')

	prev_table = None
	idx = 1

	for line in  backup_file:
		print idx
		idx += 1
		# reproduce configuration
		if line.startswith('SET '):
			dml_file.write(line)

		# detect tables to prune
		if line.startswith('INSERT INTO '):
			table = line.split()[2]
			# skip duplicates
			if prev_table == table:
				continue
			prev_table = table
			dml_file.write('delete from %s;\n' % table)

	dml_file.close()
	backup_file.close()

#==================================================================
# main
#------------------------------------------------------------------
if __name__ == "__main__" :

	_log.SetAllLogLevels(gmLog.lData)

	generate_pruning_dml(sys.argv[1])

#==================================================================
# $Log: gmDBPruningDMLGenerator.py,v $
# Revision 1.1  2007/11/04 01:28:07  ncq
# - first version
#
#
